
'use strict';
jQuery(function($) {
    $.fn.vcSineBackground = function(Options, Callback) {
        var CreateElement = $(this);
        var ElementId = CreateElement.attr("id");
        var parentRow = getParentRow(CreateElement);
        parentRow.css("position", "relative");
        var Element = parentRow.prepend('<div id="' + ElementId + '" class="vc-sine-background-bg"><canvas id="' + ElementId +  '-output"></canvas></div>');

		
		$("#" + ElementId + "-output").hexagonizedWave({
			  spacing: (CreateElement.attr("data-spacing")) ? parseInt(CreateElement.attr("data-spacing")) : 50,
			  baseSize: (CreateElement.attr("data-basesize")) ? parseInt(CreateElement.attr("data-basesize")) : 25,
			  addedSize: (CreateElement.attr("data-addedsize")) ? parseInt(CreateElement.attr("data-addedsize")) : 20,
			  
			  multX: (CreateElement.attr("data-multx")) ? parseFloat(CreateElement.attr("data-multx")) : .5,
			  multY: (CreateElement.attr("data-multy")) ? parseFloat(CreateElement.attr("data-multy")) : 0.9,
			  multSum: (CreateElement.attr("data-multsum")) ? parseFloat(CreateElement.attr("data-multsum")) : 0.1,
			  tickSpeed: (CreateElement.attr("data-tickspeed")) ? parseFloat(CreateElement.attr("data-tickspeed")) : .01,
			  hueMult: (CreateElement.attr("data-huemult")) ? parseInt(CreateElement.attr("data-huemult")) : 0,
			  saturation: (CreateElement.attr("data-saturation")) ? parseInt(CreateElement.attr("data-saturation")) : 100,
			  lightness: (CreateElement.attr("data-lightness")) ? parseInt(CreateElement.attr("data-lightness")) : 65,
			  opacity:(CreateElement.attr("data-opacity")) ? parseFloat(CreateElement.attr("data-opacity")) : 1,
			  hueFrom: (CreateElement.attr("data-huefrom")) ? parseInt(CreateElement.attr("data-huefrom")) : 336,
			  hueMax: (CreateElement.attr("data-huemax")) ? parseInt(CreateElement.attr("data-huemax")) : 51,
			  shape: CreateElement.attr("data-shape") ? CreateElement.attr("data-shape") : "triangle"
			});

        CreateElement.remove();

        function getParentRow(Element) {
            return Element.parents(".boomapps_vcrow, .vc_row, .wpb_row").eq(0);
        }
    }


    $(".vc-sine-background").each(function() {
        $(this).vcSineBackground();
    });



});